﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Obroty wg dni</title>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">

Hashtable ht = new Hashtable();

public class Total : IComparable {
    decimal przychód;
    decimal rozchód;
    readonly Date data;

    public Total(Date data) {
        this.data = data;
    }
    public void Add(Obrot o) {
        przychód += o.Przychod.Wartosc;
        rozchód += o.Rozchod.Wartosc;
    }
    public Date Data {
        get { return data; }
    }
    public decimal Przychód {
        get { return przychód; }
    }
    public decimal Rozchód {
        get { return rozchód; }
    }
    public decimal Marża {
        get { return Rozchód-Przychód; }
    }
    public Percent MarżaProcent {
        get { 
			if (Rozchód==0) return Percent.Blank;
			return new Percent(Marża/Rozchód); 
		}
    }
    public Percent NarzutProcent {
        get { 
			if (Przychód==0) return Percent.Blank;
			return new Percent(Marża/Przychód); 
		}
    }
    
    public int CompareTo(object obj) {
		Total t = (Total)obj;
		return data.CompareTo(t.Data);
    }
}

void dc_ContextLoad(Object sender, EventArgs args) {
    MagazynyModule mm = MagazynyModule.GetInstance(dc);
    Soneta.Handel.DokumentyParams pars = (Soneta.Handel.DokumentyParams)
		dc[typeof(Soneta.Handel.DokumentyParams)];
    FromTo okres = pars.OkresDat;
    Magazyn magazyn = (Magazyn)dc[typeof(Magazyn)];
    
   Soneta.Business.View vw = mm.Obroty.WgMagazyn.CreateView();
    if (magazyn!=null)
		vw.Condition &= new FieldCondition.Equal("Magazyn", magazyn);
	vw.Condition &= new FieldCondition.Contain("Rozchod.Data", okres);
	vw.Condition &= new FieldCondition.Equal("Rozchod.Typ", TypPartii.Magazynowy);
	vw.Condition &= new FieldCondition.Equal("Przychod.Typ", TypPartii.Magazynowy);
	
	foreach (Obrot obrót in vw) {
		if (obrót.Korekta==KorektaObrotu.StornoZasobu) continue;
		Total total = (Total)ht[obrót.Rozchod.Data];
		if (total==null) {
			total = new Total(obrót.Rozchod.Data);
			ht[obrót.Rozchod.Data] = total;
		}
		total.Add(obrót);
	}

    ArrayList lista = new ArrayList(ht.Values);
    lista.Sort();
    Grid.DataSource = lista;
}

		</script>
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Obroty wg dni|</STRONG>Magazyn:<STRONG> {1}</STRONG>|Okres:<STRONG> {2}</STRONG>|Partia:<STRONG> {3}, </STRONG>Typ:<STRONG> {4}</STRONG>"
				runat="server" DataMember1="DokumentyParams.Magazyn" DataMember2="DokumentyParams.OkresDat" DataMember3="DokumentyParams.FiltrTypuPartii" DataMember4="DokumentyParams.FiltrTypu"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" GroupData0="Data" GroupLine="Tydzień: {0:w}" ShowGroupSum="True">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="16" Align="Center" DataMember="Data" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Center" DataMember="Data" Total="Info" Caption="Dzień tygodnia" Format="{0:dddd}" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="16" Align="Right" DataMember="Przych&#243;d" Total="Sum" Caption="Przych&#243;d~netto"
						Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="16" Align="Right" DataMember="Rozch&#243;d" Total="Sum" Caption="Rozch&#243;d~netto"
						Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="16" Align="Right" DataMember="Marża" Total="Sum" Caption="Marża~Wartość"
						Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Right" DataMember="MarżaProcent" Caption="Marża~%" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="NarzutProcent" Caption="Marża~Narzut %" EncodeHTML="True" runat="server"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>

